% Matlab program which performs image segmentation using the morphological
% methodology like Watershed algorithm.
% The program is divided into parts, PART A and PART B.
% PART A is the watershed algorithm based on the gradient operator
% PART B is the watershed algorithm based on the marker controlled.
% Marker controlled watershed method is effective than the gradient method
% becase the graident method provides the oversegmentation of the image.
% -------------------------------------------------------------------------

% PART 'A'
% WATERSHED TRANSFORM BASED ON THE GRADIENT MAGNITUDE
%--------------------------------------------------------------------------


% The program which is written below is based on the following steps of the
% watershed alogrithm.
% 1. Read the image into Matlab.
% 2. Convert the image into the gray scale iamge
% 3. Rescale the image.
% 4. Caluclate the gradient magnitued. Gradient magnitude can be computed
%    using operators filters
% 5. Apply the watershed transform to the gradient magnitude and segment
%    the image
% 6. Display both the input and the output images.
%--------------------------------------------------------------------------

% Some of the important matlab functions used are
% 1.fspecial, 2.imfilter, 3.imopen 4.imclose
%--------------------------------------------------------------------------

% im = the input image
% im_gy is the grayscale image
% ax and ay are specifies the 2-dimensional filter
% mag_grad is the magnitude gradient
% output_1 is the image obtained after applying the watershed transform on
% gradient magnitude
%--------------------------------------------------------------------------


im=imread('C:\Documents and Settings\mamta naik\Desktop\brain_mri_transversal_t1_002.jpg'); %read the input image 
im_gy = rgb2gray(im);     % convert the image into gray scale
imshow(im_gy)             % display the input iamge 


ax = fspecial('sobel');   % Function 'fspecial' returns the ('sobel') returns 3-by-3 filter that emphasizes
                          % horizontal edges utilizing the smoothing effect by approximating a
                          % vertical gradient. 
ay = ax';                 % In order to emphasize on vertical edges, transpose is taken


Ay = imfilter(double(im_gy), ay, 'replicate');  % Function 'imfilter performs the multidimensional filtering in such a way
Ax = imfilter(double(im_gy), ax, 'replicate');  % that the resultant images Ax and Ay have the same class and size as im_gy
                                                % 'replicate'is the filter used in multidimaensional filtering
                                                %  in which, Input array values outside the bounds of the array
                                                % are assumed to equalto the nearest array border value
                                                
mag_grad = sqrt(Ax.^2 + Ay.^2);                     % the gradient magnitude is calculated 
gradm=imclose(imopen(mag_grad,ones(3,3)),ones(3,3)); % ones(3,3) is a 3x3 matrix of ones
                                                     % imopen(mag_grad,ones) performs opening with the structuring element
                                                     % strel(nhoob), where nhoob is a 3x3 matrix of ones
    
figure, imshow(gradm,[]), title('Gradient Magnitude')   %Display the gradient magnitude
                                                        % the empty matrix
                                                        % [] is used for
                                                        % [low,high] which
                                                        % means that
                                                        %imshow uses [min(I(:)) max(I(:))]; the
                                                        %minimum value in I displays as black, and the maximum value displays
                                                        %as white

output_1 = watershed(gradm);                         % Apply the watershed transform on the gradient magnitude
                                                     % Function  L = watershed(A) computes a label matrix identifying the watershed
                                                     % regions of the input matrix A.  A can have any dimension.  The elements
                                                     
  figure, imshow(output_1), title('Gradient magnitude watershed transform') % Display the output image
%--------------------------------------------------------------------------

% PART B
% WATERSHED TRANSFORM USING MARKER CONTROLLED
%--------------------------------------------------------------------------

% The marker controlled watershed consists the following steps
% 1. Mark the foregroung objects
% 2. Mark the background objects 
% 3. The watershed transform is applied on the image 
%--------------------------------------------------------------------------

% The important Matlab functions used are
% 1. imerode 2. imdilate 3. imreconstruct 4.imextendedmin 5.bwareaopen
%--------------------------------------------------------------------------

% 
%
%
%
%-------------------------------------------------------------------------

% SELECTING FOREGROUND MARKERS
%--------------------------------------------------------------------------


se=strel('disk',2,0);                             % the structural element chosen is disk shaped
erod_val = imerode(im_gy, se);                    % imerode and imreconstruct are  used to 'clean up the image, 
                                                  % that is obtaim a flat minima
erod_val1 = imreconstruct(erod_val, im_gy);       % the flat minima created be traced out later.
dil_val = imdilate(erod_val1, se);                % the erosion operation is followed by dilation
dil_val1 = imreconstruct(imcomplement(dil_val), imcomplement(erod_val1)); % function 'imreconstruct' is used instead of ierode and 
                                                                          % idilate alone because it gives more effective results
dil_val1=imcomplement(dil_val1);                     % the input and the output images are complemented


min_ft = imextendedmin(dil_val1,20);               % calcuate the regional minima
                                                    %calculating the
                                                    %regional minima is
                                                    %necessary to obtain
                                                    %good foregroung
                                                    %markers
                                                   % function BW = imextendedmin(I,H) computes the extended-minima transform, which
                                                   % is the regional minima of the H-minima transform.  H is a nonnegative
                                                   % scalar.
                                                   %Regional minima are connected components of pixels with the same
                                                  %intensity value, t, whose external boundary pixels all have a value
                                                   %greater than t.
im_1 = im_gy;                                     % superimposing the regional minima and the input image inorder to evaluate the result
im_1(min_ft) = 255;


se2 = strel(ones(3,3));                        % The morphological operators are used in order to obtain proper segmentation results
min_ft1 = imclose(min_ft, se2);                % this is the optional step in the program
min_ft2 = imerode(min_ft1, se2);
min_ft3= bwareaopen(min_ft2, 2);             % the function 'bwareaopen' removes any small objects if presents within the image
im_2 = im_gy;                                 % superimpose the images to evaluate(interpret) the result
im_2(min_ft3) = 255;                         %(BW,P) removes from a binary image all connected
                                             %components (objects) that have fewer than P pixels (in this program '2', producing another
                                              %binary image BW2.  The default connectivity is 8 for two dimensions,

 figure, imshow(im_2)                             
title('Regional minima & original image')      % display the output
%--------------------------------------------------------------------------

% SELECTING THE BACKGROUND MARKERS
%--------------------------------------------------------------------------

bin_in = im2bw(dil_val1, graythresh(dil_val1));      % Perform the thresholding
                                                     % in the dil_val1 the
                                                     % dark pixels belonged
                                                     % to the
                                                     % background.That is
                                                     % why, we use dil_val1
                                                     % so that thresholding
                                                     % can be performed
                                                     % directly
figure, imshow(bin_in), title('thresholded image')   % Display the thresholded image

dis = bwdist(bin_in);                                % Apply the wateshed transform
dis_1 = watershed(dis);
num1 = dis_1 == 0;

gradf = imimposemin(gradm, num1 | min_ft3);          % Function 'imimposemin' modifies the intensity image I using
                                                      %morphological
                                                      %reconstruction so it
                                                      %only has regional
                                                      %minima wherever BW
                                                      %value is not zero

L = watershed(gradf);
im_3 = im_gy;
im_3(imdilate(L == 0, ones(3, 3)) | num1 | min_ft3) = 255;
figure, imshow(im_3)
title('Markers and object boundaries superimposed on original image') % Display the output iamge

